/**
 * Javascript to manage the paging dropdown control.
 *
 * @module     core/paged_content_paging_dropdown
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/paged_content_paging_dropdown",["jquery","core/custom_interaction_events","core/paged_content_events","core/pubsub"],(function($,CustomEvents,PagedContentEvents,PubSub){var SELECTORS_DROPDOWN_ITEM='[data-region="dropdown-item"]',SELECTORS_DROPDOWN_TOGGLE='[data-region="dropdown-toggle"]',SELECTORS_ACTIVE_DROPDOWN_ITEM='[data-region="dropdown-item"].active',SELECTORS_CARET='[data-region="caret"]',getPageNumber=function(item){return parseInt(item.attr("data-page-number"),10)},getAllItems=function(root){return root.find(SELECTORS_DROPDOWN_ITEM)},getPreviousItems=function(root,item){var pageNumber=getPageNumber(item);return getAllItems(root).filter((function(index,element){return getPageNumber($(element))<pageNumber}))},getLimit=function(item){return parseInt(item.attr("data-item-count"),10)},getOffset=function(root,item){if(null!=item.attr("data-offset"))return parseInt(item.attr("data-offset"),10);var offset=0;return getPreviousItems(root,item).each((function(index,prevItem){prevItem=$(prevItem),offset+=getLimit(prevItem)})),item.attr("data-offset",offset),offset},getActiveItem=function(root){return root.find(SELECTORS_ACTIVE_DROPDOWN_ITEM)},setActiveItem=function(root,item,id){var eventPayload=function(root,items){return items.map((function(index,item){return item=$(item),{pageNumber:getPageNumber(item),limit:getLimit(item),offset:getOffset(root,item)}})).get()}(root,getPreviousItems(root,item).add(item)),toggle=root.find(SELECTORS_DROPDOWN_TOGGLE),caret=toggle.find(SELECTORS_CARET);getActiveItem(root).removeClass("active"),item.addClass("active"),toggle.html(item.text()),toggle.append(caret),PubSub.publish(id+PagedContentEvents.SHOW_PAGES,eventPayload)};return{init:function(root,id){root=$(root),function(items){items.each((function(index,item){(item=$(item)).attr("data-page-number",index+1)}))}(getAllItems(root));var activeItem=getActiveItem(root);activeItem.length&&setActiveItem(root,activeItem,id),CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_DROPDOWN_ITEM,(function(e,data){var item=$(e.target).closest(SELECTORS_DROPDOWN_ITEM);setActiveItem(root,item,id),data.originalEvent.preventDefault()}))},rootSelector:'[data-region="paging-dropdown-container"]'}}));

//# sourceMappingURL=paged_content_paging_dropdown.min.js.map